SFP = SFP or {}
SFP.CONFIG = SFP.CONFIG or {}
SFP.DBSTATUS = {
    INITIALIZING = 0,
    MIGRATING = 1,
    SUCCESS = 2,
    FAILED = 3
}

local all_configuration = {}

local config = {}
config.__index = config

SFP.CONFIG = function(sKey)
    -- Aw:LogTrace("Initialized config table for %s", sKey)
    local t = all_configuration[sKey]
    if not t then
        t = setmetatable(config, {
        })
        all_configuration[sKey] = t
    end
    return t
end

function config:Add(sKey, xValue)

    config[sKey] = xValue
    return self
end

function config:Get(sKey)
    return config[sKey]
end

function config:Set(sKey, xValue)
    if not config[sKey] then
        Aw:LogTrace( "Trying to set invalid config for key %s, value: %s", sKey, tostring(xValue) )
        return
    end
    config[sKey] = xValue
    return self
end