

SFP._tModules = SFP._tModules or {}
SFP._tConcommads = SFP._tConcommads or {}

function SFP:ShouldLoad(tModule)
  if !tModule.Name || !tModule:CanLoad(SFP.DB.STATUS) || !tModule.Enabled  then return false end
  return true
end

function SFP:RegisterModule(tModule)
  -- if SFP._tModules[tModule.Name] then return end
  Aw:LogTrace("Registering module %s : Version %s", tModule.Name, tModule.Version or "Undefined version")

  if not self:ShouldLoad(tModule) then
    Aw:LogTrace("Module %s is registered, but not loaded", tModule.Name)
    return
  end

  SFP._tModules[tModule.Name] = tModule

  if tModule.OnLoad then tModule:OnLoad() end

  if (timer.Exists("_load.sfpModules")) then
    timer.Remove("_load.sfpModules")
  end

  timer.Create("_load.sfpModules", 2, 1, function()
    hook.Run("SFP:ModulesLoaded")
    SFP:Tick()
    timer.Remove("_load.sfpModules")
  end)

end


function SFP:FireDB()
  for Name, tModule in pairs(SFP._tModules) do
    if tModule.Migrations then
      tModule:Migrations()
    end
  end
end

function SFP:RegisterCommand(sCommand, fCallback, MODULE)
  Aw:LogTrace("Trying to register console command sfp_%s", sCommand)

  if SFP._tConcommads[sCommand] then
    Aw:LogTrace("Not registering command %s - It already exists\nCouple of reasons are:\nAre you creating a module with the same command?\nYou probably have refresh lua enabled.", sCommand)
    return
  else
    if not MODULE:CanLoad() then
      Aw:LogTrace("Registered command  sfp_%s but it will not be enabled : Module shouldn't load", sCommand)
      return
    end
    concommand.Add("sfp_" .. sCommand, fCallback)
    SFP._tConcommads[sCommand] = { run = fCallback, module = MODULE}
    Aw:LogTrace("Registered the command sfp_%s succsessfully : All good", sCommand)
  end

end

function SFP:Tick()
  Aw:LogTrace("SFP | Starting data update tick")
  timer.Create("SFP:Tick", SFP.CONFIG("General"):Get("updateInterval"), 0, function()
    count = 0
    for moduleName, MODULE in pairs(SFP._tModules) do
      timer.Simple(count, function()
        if MODULE.Fetch then MODULE:Fetch() end
        count = count + 2
        if table.Count(SFP._tModules) == count then
          count = 0
        end
      end)
    end
  end)
end