local MODULE = {}
MODULE.Name = "BanSyncs"
MODULE.Version = 1.5
MODULE.Enabled = true

function MODULE:CanLoad()
  return SFP.CONFIG("General"):Get("enableBanSync")
end

function MODULE:Migrations()
  Aw:LogTrace("Running Ban Migrations....")
  MODULE._tBans = {}
  local serverConn = string.Explode(  ":", SFP.CONFIG("General"):Get("ServerIP") )
  local ip = serverConn[1]
  local port = serverConn[2]
  
  local query = [[
    SELECT id
    FROM `sfp_servers`
    WHERE ip = ':ip:'
    AND port = ':port:'
    AND game = 'garrysmod'
  ]]

  query = query:Replace(":ip:", ip)
  query = query:Replace(":port:", port)

  local queryServer = SFP.DB:Get():query(query)

  function queryServer:onSuccess(row)
    if #row == 0 then
      Aw:LogTrace("THIS SERVER IS NOT REGISTERED ON PANEL - PLEASE ADD THE SERVER.\n: query %s", query)
      Aw:LogTrace("Server bansync is now disabled because we couldn't find the ServerID on panel database!")
      return
    else
      Aw:LogTrace("Server -> Panel ID identified : %s : All good", row[1].id)
    end

    MODULE._ServerID = row[1].id
    Aw:LogTrace("This server ID: %s : All good", row[1].id)
    local query = [[
      SELECT * 
      FROM `sfp_bans`
      WHERE ServerID = ':server:'
    ]]

    query = query:Replace(":server:", row[1].id)

    queryBanList = SFP.DB:Get():query(query)
      
    function queryBanList:onSuccess(rows)
      if #rows == 0 then
        return
      end

      for i = 1, #rows do
        local row = rows[i]
        
        MODULE._tBans[row.PSteamID] = {
          start = row.Time,
          length = row.Length,
          adminID = row.ASteamID,
          target = row.PSteamID,
          reason = row.Reason
        }

        local player = player.GetBySteamID64(row.PSteamID)

        if (player and player:Nick()) then
          if (tonumber(row.Length) > os.time() ) then
            player:Kick(string.format(
              "You're banned from this server\nReason: <%s>\nAdminID: <%s>\nUntil: <%s>",
              row.Reason or "<Not available>",
              row.ASteamID or "<Console?>",
              row.Length == 0 and "Forever" or os.date("%c", row.Length)
            ))
          end
        end
      end

      MODULE:CheckPassword()
    end

    function queryBanList:OnError(err)
      Aw:LogTrace("Failed fetching bans from database : err %s\n: query %s", err, query)
    end

    queryBanList:start()
  end

  function queryServer:onError(err)
    Aw:LogTrace("Error while fetching server ID on panel database : err %s\n: query %s", err, query)
  end

  queryServer:start()

  
  timer.Create("SFP_SyncBans", 1 * 60, 0, function()
    if (not SFP.CONFIG("General"):Get("enableAutoBanUpdate")) then return end
    MODULE:Migrations()
  end)

end

function MODULE:CheckPassword()
 Aw:LogTrace("Enabled ban checking before server join!")

  hook.Add("CheckPassword", "SFP:WaitBansLoading", function(sid64, ip, svPass, clPass, name)

    local sid = util.SteamIDFrom64( sid64 )
    local banTbl
    if MODULE._tBans[sid64] then
        banTbl = MODULE._tBans[sid64]
    elseif sid and MODULE._tBans[sid] then
        banTbl = MODULE._tBans[sid]
    end

    if not banTbl then
        return
    else
        Aw:LogTrace("PLAYER WITH BAN HISTORY JOINED THE SERVER! Player: %s checking if expired : Start good", sid64)
    end

    if banTbl.length == 0 then
      return false, string.format(
        "You're banned from this server\nReason: <%s>\nAdminID: <%s>\nUntil: <%s>",
        banTbl.reason or "<Not available>",
        banTbl.adminID or "<Console?>",
        "<Permanent ban>"
      )
    end

    if (tonumber(banTbl.length) > os.time() ) then

      return false, string.format(
        "You're banned from this server\nReason: <%s>\nAdminID: <%s>\nUntil: <%s>",
        banTbl.reason or "<Not available>",
        banTbl.adminID or "<Console?>",
        banTbl.length and os.date("%H:%M:%S - %d/%m/%Y", banTbl.length) or "<Permanent ban>"
      )
    end
  end)


end

function MODULE:OnLoad()
  local serverConn = string.Explode(  ":", SFP.CONFIG("General"):Get("ServerIP") )
  
  self._tMods = {}
  self._tBans = {}
  -- self._ServerID = 0
  self._ServerIP = serverConn[1]
  self._ServerPort = serverConn[2]

  self._tMods['ulx'] = {
    tableName = "ulib_bans",
    convertTime = function(input)
    end,
    sqlMigrate = function()
      local query = [[
        SELECT * FROM `ulib_bans`
      ]]

      local rows = sql.Query(query)

      if not rows or #rows == 0 then
        Aw:LogTrace("Not able to sync bans : adminmod %s\n: No bans found to import or database not found", "ulx")
        return
      end

      local queryBase = [[
        INSERT INTO `sfp_bans` (PName, Time, Length, AName, Reason, ServerID)
        VALUES ]]

      for i = 1, #rows do
        local sid64 = rows[i].steamid
        local name = rows[i].name
        local reason = rows[i].reason
        local start = rows[i].time
        local length = rows[i].unban
        local adminName = rows[i].admin

        local insertBase = [[ (':name:', ':start:', ':length:', ':adminName:', ':reason:', ':serverid:'),]]
        insertBase = insertBase:Replace(":serverid:", self._ServerID)

        insertBase = insertBase:Replace(":name:", name)
        insertBase = insertBase:Replace(":start:", start)
        insertBase = insertBase:Replace(":length:", length)
        insertBase = insertBase:Replace(":adminName:", adminName)
        insertBase = insertBase:Replace(":reason:", reason)

        queryBase = queryBase .. insertBase
      end


      if string.EndsWith( queryBase, ',' ) then
        queryBase = string.sub( queryBase, 1, -2 ) .. ";"
      end

      queryInsert = SFP.DB:Get():query(queryBase)

      function queryInsert:onSuccess(last_insert)
        Aw:LogTrace("Migrated ulx bans from SQLite to Portal")
      end

      function queryInsert:onError(err)
        Aw:LogTrace("Failed ulx bans migrations : err %s\n: query %s", err, queryBase)
      end

      queryInsert:start()


    end,
    mysqlMigrate = function()
      local query = [[
        SELECT * FROM `ulib_bans`
      ]]

      local queryBase = [[
        INSERT INTO `sfp_bans` (PName, Time, Length, AName, Reason, ServerID)
        VALUES ]]

      local queryDB = SFP.DB:Get():query(query)

      function queryDB:onSuccess(rows)

        for i = 1, #rows do
          local sid64 = rows[i].steamid
          local name = rows[i].name
          local reason = rows[i].reason
          local start = rows[i].time
          local length = rows[i].unban
          local adminName = rows[i].admin

          local insertBase = [[ (':name:', ':start:', ':length:', ':adminName:', ':reason:', ':serverid:'),]]
          insertBase = insertBase:Replace(":serverid:", self._ServerID)

          insertBase = insertBase:Replace(":name:", name)
          insertBase = insertBase:Replace(":start:", start)
          insertBase = insertBase:Replace(":length:", length)
          insertBase = insertBase:Replace(":adminName:", adminName)
          insertBase = insertBase:Replace(":reason:", reason)

          queryBase = queryBase .. insertBase
        end

        local queryInsert = SFP.DB:Get():query(queryBase)
        function queryInsert:onSuccess(rows)
          Aw:LogTrace("Migrated ulx bans from SQLite to Portal")
        end
        function queryInsert:onError(err)
          Aw:LogTrace("Failed ulx bans migrations : err %s\n: query %s", err, query)
        end
        queryInsert:start()

      end

      function queryDB:onError(err)
        Aw:LogTrace("Failed ulx bans migrations : err %s\n: query %s", err, query)
      end

      queryDB:start()
    end,
    getConnector = function()
      return "sqlite"
    end
  }

  self._tMods['serverguard'] = {
    tableName = "sfp_bans",
    convertTime = function(input)

    end,
    sqlMigrate = function()
      local query = [[
        SELECT * FROM `serverguard_bans`
      ]]

      local rows = sql.Query(query)

      if not rows or #rows == 0 then
        Aw:LogTrace("Not able to sync bans : adminmod %s\n: No bans found to import or database not found",  "serverguard")
      end

      local queryBase = [[
        INSERT INTO `sfp_bans` (PName, Time, Length, AName, Reason, ServerID)
        VALUES ]]

      for i = 1, #rows do
        local sid64 = rows[i].community_id
        local name = rows[i].player
        local reason = rows[i].reason
        local start = rows[i].start_time
        local length = rows[i].end_time
        local adminName = rows[i].admin

        local insertBase = [[ (':name:', ':start:', ':length:', ':adminName:', ':reason:', ':serverid:'),]]
        insertBase = insertBase:Replace(":serverid:", self._ServerID)

        insertBase = insertBase:Replace(":name:", name)
        insertBase = insertBase:Replace(":start:", start)
        insertBase = insertBase:Replace(":length:", length)
        insertBase = insertBase:Replace(":adminName:", adminName)
        insertBase = insertBase:Replace(":reason:", reason)

        queryBase = queryBase .. insertBase
      end


      if string.EndsWith( queryBase, ',' ) then
        queryBase = string.sub( queryBase, 1, -2 ) .. ";"
      end

      queryInsert = SFP.DB:Get():query(queryBase)

      function queryInsert:onSuccess(last_insert)
        Aw:LogTrace("Migrated serverguard bans from SQLite to Portal")
      end

      function queryInsert:onError(err)
        Aw:LogTrace("Failed serverguard bans migrations : err %s\n: query %s", err, queryBase)
      end

      queryInsert:start()

    end,
    mysqlMigrate = function()
      local query = [[
        SELECT * FROM `serverguard_bans`
      ]]

      local queryBase = [[
        INSERT INTO `sfp_bans` (PName, Time, Length, AName, Reason, ServerID)
        VALUES ]]

      local queryDB = SFP.DB:Get():query(query)

      function queryDB:onSuccess(rows)

        for i = 1, #rows do
          local sid64 = rows[i].community_id
          local name = rows[i].player
          local reason = rows[i].reason
          local start = rows[i].start_time
          local length = rows[i].end_time
          local adminName = rows[i].admin

          local insertBase = [[ (':name:', ':start:', ':length:', ':adminName:', ':reason:', ':serverid:'),]]
          insertBase = insertBase:Replace(":serverid:", self._ServerID)

          insertBase = insertBase:Replace(":name:", name)
          insertBase = insertBase:Replace(":start:", start)
          insertBase = insertBase:Replace(":length:", length)
          insertBase = insertBase:Replace(":adminName:", adminName)
          insertBase = insertBase:Replace(":reason:", reason)

          queryBase = queryBase .. insertBase
        end

        local queryInsert = SFP.DB:Get():query(queryBase)
        function queryInsert:onSuccess(rows)
          Aw:LogTrace("Migrated serverguard bans from SQLite to Portal")
        end
        function queryInsert:onError(err)
          Aw:LogTrace("Failed serverguard bans migrations : err %s\n: query %s", err, query)
        end
        queryInsert:start()

      end

      function queryDB:onError(err)
        Aw:LogTrace("Failed serverguard bans migrations : err %s\n: query %s", err, query)
      end

      queryDB:start()
    end,
    getConnector = function()
      if (serverguard.mysql:GetModule() == "sqlite") then
        return "sqlite"
      else
        return "mysqloo"
      end
    end
  }

  self._tMods['sadmin'] = {
    tableName = "sadmin_bans",
    convertTime = function(input)
    end,
    sqlMigrate = function()
        local query = [[
          SELECT * FROM `sadmin_bans`
        ]]
  
        local rows = sql.Query(query)
  
        if not rows or #rows == 0 then
          Aw:LogTrace("Not able to sync bans : adminmod %s\n: No bans found to import or database not found", "ulx")
          return
        end
  
        local queryBase = [[
          INSERT INTO `sfp_bans` (PName, Time, Length, AName, Reason, ServerID)
          VALUES ]]
  
        for i = 1, #rows do
          local sid64 = rows[i].sid64
          local name = rows[i].sid64
          local reason = rows[i].reason
          local start = os.time()
          local length = rows[i].expiration
          local adminName = rows[i].admin_sid64
  
          local insertBase = [[ (':name:', ':start:', ':length:', ':adminName:', ':reason:', ':serverid:'),]]
          insertBase = insertBase:Replace(":serverid:", self._ServerID)
  
          insertBase = insertBase:Replace(":name:", name)
          insertBase = insertBase:Replace(":start:", start)
          insertBase = insertBase:Replace(":length:", length)
          insertBase = insertBase:Replace(":adminName:", adminName)
          insertBase = insertBase:Replace(":reason:", reason)
  
          queryBase = queryBase .. insertBase
        end
  
        if string.EndsWith( queryBase, ',' ) then
          queryBase = string.sub( queryBase, 1, -2 ) .. ";"
        end
  
        queryInsert = SFP.DB:Get():query(queryBase)
        function queryInsert:onSuccess(last_insert)
          Aw:LogTrace("Migrated sadmin bans from SQLite to Portal")
        end
  
        function queryInsert:onError(err)
          Aw:LogTrace("Failed sadmin bans migrations : err %s\n: query %s", err, queryBase)
        end
  
        queryInsert:start()
    end,
    mysqlMigrate = function()
    end,
    getConnector = function()
    end
  }

  self._tMods['xadmin2'] = {
    tableName = "",
    convertTime = function(input)
    end,
    sqlMigrate = function()
    end,
    mysqlMigrate = function()
    end,
    getConnector = function()
    end
  }
  
  if SFP.CONFIG("General"):Get("enableBetaBans") then
    self:ApplyAdminPatch()
  end
end

function MODULE:GetAdminMod()
  if (serverguard ) then
    return "serverguard"
  elseif (ulx) then
    return "ulx"
  elseif (xAdmin) then
    return "xadmin"
  elseif (sAdmin) then
    return "sadmin"
  else
    return false
  end
end

function MODULE:GetDBConnector()
  local mod = MODULE:GetAdminMod()

  return self._tMods[mod]:getConnector()
end

function MODULE:Sync(sCmd, tArgs)
  local self = SFP._tModules["BanSyncs"] -- Lua is stupid...
  
  local mod = self:GetAdminMod()
  local connector = self:GetDBConnector()
  
  if not mod then
    Aw:LogTrace("No admin mod detected : Here's why it may happen:\n- Your admin mod is not supported by sfportal yet\n- You're using a modified version of the admin mod?\n- Contact us on our support discord if you think this is a mistake.")
    return
  end
  
  Aw:LogTrace("Syncing bans with connector: %s", connector)
  if connector == "sqlite" then
    self._tMods[mod]:sqlMigrate()
  else
    self._tMods[mod]:mysqlMigrate()
  end
end

function MODULE:Ban(sCmnd, tArgs)
  local sid64, length, asid64, reason = tArgs[1], tArgs[2], tArgs[3], tArgs[4]

  MODULE._tBans[sid64] = {
    start = os.time(),
    length = length,
    adminID = asid64 == 0 and false or asid64,
    target = sid64,
    reason = reason
  }

  PrintTable(MODULE._tBans)

  local pTarget = player.GetBySteamID64( sid64 )
  if not pTarget then
    Aw:LogTrace("Received ban from panel, but player is not on the server : All good")
    return
  end

  pTarget:Kick(reason)
end

function MODULE:UnBan(sCmnd, tArgs)
  local sid64 = tArgs[1]

  if not MODULE._tBans[sid64] then
    Aw:LogTrace("Received unban from panel, but player is not on bans cache")
    return
  end

  MODULE._tBans[sid64] = nil

end

function MODULE:unbanPlayer(steamid, admin_name)
	local query =  SFP.DB:Get():prepare("SELECT * FROM `sfp_bans` WHERE (PSteamID, ServerID) IN ((?, ?), (?, ?))")
	query:setString(1, steamid)
	query:setNumber(2, MODULE._ServerID)
	query:setString(3, steamid)
	query:setString(4, "*")


	query.onSuccess = function(q, data)
        PrintTable(data)
        
		if (#data == 0) then
      MODULE._tBans[steamid] = nil
		else
			for k, v in pairs (data) do
                local query = [[
                	UPDATE sfp_bans SET Length = :time: WHERE sfp_bans.BanID = :banid:
                ]]
                query = query:Replace(":banid:", data[1].BanID)        
                query = query:Replace(":time:", os.time() - 1)
                
				local q =  SFP.DB:Get():query(query)
				
                q.onSuccess = function(q, row)
                    Aw:LogTrace("Found ban id %s - Removing : All good", data[1].BanID)
                	MODULE._tBans[steamid] = nil
                end
				
                q.onError = function (q, err, sql)
					Aw:LogTrace("Failed to unban player " .. steamid)
                    Aw:LogTrace(err)
				end

				q:start ()
			end
		end
	end

	query.onError = function(q, err, sql)
		Aw:LogTrace("Failed to unban player " .. steamid .. " (" .. err .. ")")
	end

	query:start()
end

function MODULE:banPlayer(admin_name, admin_steamid, steamid, time, reason, community)
	print("Expected arguments:")
    print("Admin Name, Admin ID, PID, TIME, REASON, COMM")
    print(admin_name, admin_steamid, steamid, time, reason, community)
	if ((reason == nil) or (reason == 1)) then
		community = reason
		reason = time
		time = steamid
		steamid = admin_steamid
	end

	local pname = "Unknown name"
	for k, v in pairs(player.GetAll()) do
		if (v:SteamID() == steamid) then
			pname = v:Name()
			break
		end
	end

	local t = tonumber(os.time())

	local str = "INSERT INTO `sfp_bans` (PSteamID, PName, server_ip, Length, Time, reason, AName, ASteamID, ServerID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"
  local sid64 = util.SteamIDTo64(steamid)
	local query = SFP.DB:Get():prepare(str)

	query:setString(1, sid64)
	query:setString(2, pname)
	query:setString(3, community and SFP.CONFIG("General"):Get("ServerIP") or "*")
  query:setNumber(4, time > 0 and t + time or 0)
	query:setNumber(5, t)
	query:setString(6, reason)
  query:setString(7, admin_name)
  query:setString(8, admin_steamid)
	query:setNumber(9, self._ServerID)

	query.onSuccess = function(q, data)
    MODULE._tBans[sid64] = {
      start = os.time(),
      length = time > 0 and t + time or 0,
      adminID = admin_steamid and admin_steamid or "CONSOLE",
      target = sid64,
      reason = reason
    }

    local pTarget = player.GetBySteamID64( sid64 )

    if not pTarget then
      return
    end


    pTarget:Kick(string.format(
      "You're banned from this server\nReason: <%s>\nAdminID: <%s>\nUntil: <%s>",
      reason or "<Not available>",
      admin_steamid or "<Console?>",
      os.date("%H:%M:%S - %d/%m/%Y", time > 0 and t + time or 0) or "<Permanent ban>"
    ))
	end

	query.onError = function(q, err, sql)
    Aw:LogError(err, "Error during ban function")
	end

	query:start()

  MODULE:CheckPassword()

end

function MODULE:ApplyAdminPatch()
	if (ulx != nil) then
		local key = -1
		for k, v in pairs(ulx.cmdsByCategory["Utility"]) do
			if (v.cmd == "ulx banid") then
				key = k
			end
		end

		if (key != -1) then
			local banid = ulx.cmdsByCategory["Utility"][key]
			table.remove (banid.args, 4)
			banid:addParam{ type=ULib.cmds.StringArg, hint="reason", ULib.cmds.optional, completes=ulx.common_kick_reasons }
			banid:addParam{ type=ULib.cmds.NumArg, hint="community, 0 for current server, 1 for all", ULib.cmds.optional, min=0 }
		end

		local oldFn = ulx.cmdsByCategory["Utility"][key].fn

		ulx.cmdsByCategory["Utility"][key].fn = function (calling_ply, steamid, minutes, reason, community)
			if (IsValid(calling_ply)) then
				self:banPlayer(calling_ply:Name(), calling_ply:SteamID(), steamid, minutes * 60, reason, community)
				return
			end
			self:banPlayer("CONSOLE", "CONSOLE", steamid, minutes * 60, reason, community)
		end

		local key = -1

		for k, v in pairs(ulx.cmdsByCategory["Utility"]) do
			if (v.cmd == "ulx unban") then
				key = k
			end
		end

		local oldFn = ulx.cmdsByCategory["Utility"][key].fn

		ulx.cmdsByCategory["Utility"][key].fn = function (calling_ply, steamid)
			self:unbanPlayer(steamid)
		end

		local oldAddBan = ULib.addBan

		function ULib.addBan( steamid, time, reason, name, admin )
			if (!IsValid(admin)) then
				self:banPlayer(
                    IsValid(admin) and admin:GetName() or "CONSOLE",
                    IsValid(admin) and admin:SteamID() or "STEAM:CONSOLE", 
                    steamid, 
                    time * 60, 
                    reason,
                    true
                )
				return
			end

			self:banPlayer(
                IsValid(admin) and admin:GetName() or "CONSOLE", 
                IsValid(admin) and admin:SteamID() or "STEAM:CONSOLE", 
                steamid, 
                time * 60, 
                reason, 
                true
            )
		end

		local oldUnBan = ULib.unban
		function ULib.unban( steamid, admin )
			self:unbanPlayer(admin)
		end
	end

	if (evolve != nil) then
		function evolve:Ban( steamid, length, reason, adminuid )
		end

		local key = -1

		for k, v in pairs(evolve.plugins) do
			if (v.Title == "Ban") then
				key = k
			end
		end

		if (key != -1) then
			evolve.plugins[key].Call = function(plugin, ply, args)
				print(plugin, ply, istable(ply), args)

				local time = math.Clamp( tonumber( args[2] ) or 5, 0, 10080 )

				if IsValid(ply) then
					if( ( time > 0 and ply:EV_HasPrivilege( "Ban" )) or ( time == 0 and ply:EV_HasPrivilege( "Permaban" ) ) ) then
						local uid, pl

						if ( string.match( args[1] or "", "STEAM_[0-5]:[0-9]:[0-9]+" ) ) then
							uid = evolve:UniqueIDByProperty( "SteamID", args[1] )
							pl = player.GetByUniqueID( uid )
						else
							pl = evolve:FindPlayer( args[1] )

							if ( #pl > 1 ) then
								evolve:Notify( ply, evolve.colors.white, "Did you mean ", evolve.colors.red, evolve:CreatePlayerList( pl, true ), evolve.colors.white, "?" )

								return
							elseif ( #pl == 1 ) then
								pl = pl[1]
								uid = pl:SteamID()
							end
						end

						local length = math.Clamp( tonumber( args[2] ) or 5, 0, 10080 ) * 60
						local reason = table.concat( args, " ", 3 )

						if ( #reason == 0 ) then reason = "No reason specified" end

						local nick = evolve:GetProperty( uid, "Nick" )

						self:banPlayer(ply:GetName(), pl:SteamID(), length, reason, math.Clamp(tonumber(args[4]), 0, 1))

						if ( length == 0 ) then
							evolve:Notify( evolve.colors.blue, ply:Nick(), evolve.colors.white, " banned ", evolve.colors.red, nick, evolve.colors.white, " permanently (" .. reason .. ")." )
						else
							evolve:Notify( evolve.colors.blue, ply:Nick(), evolve.colors.white, " banned ", evolve.colors.red, nick, evolve.colors.white, " for " .. length / 60 .. " minutes (" .. reason .. ")." )
						end
					else
						evolve:Notify( ply, evolve.colors.red, evolve.constants.notallowed )
					end
				else
					if ( !string.match( args[1] or "", "STEAM_[0-5]:[0-9]:[0-9]+" ) ) then
						pl = player.GetByUniqueID( uid )
					else
						pl = args[1]
					end

					local length = math.Clamp( tonumber( args[2] ) or 5, 0, 10080 ) * 60
					local reason = table.concat( args, " ", 3, #args - 1)

					if ( #reason == 0 ) then reason = "No reason specified" end

					local nick = evolve:GetProperty( uid, "Nick" )

					self:banPlayer("CONSOLE", "CONSOLE", pl:SteamID(), length, reason, math.Clamp(tonumber(args[#args]), 0, 1))

					if ( length == 0 ) then
						evolve:Notify( evolve.colors.blue, "CONSOLE", evolve.colors.white, " banned ", evolve.colors.red, nick, evolve.colors.white, " permanently (" .. reason .. ")." )
					else
						evolve:Notify( evolve.colors.blue, "CONSOLE", evolve.colors.white, " banned ", evolve.colors.red, nick, evolve.colors.white, " for " .. length / 60 .. " minutes (" .. reason .. ")." )
					end
				end
			end
		end

		key = -1
		for k, v in pairs(evolve.plugins) do
			if (v.Title == "Unban") then
				key = k
			end
		end

		if (key != -1) then
			evolve.plugins[key].Call = function(plugin, ply, args)
				self:unbanPlayer(args[1])
			end
		end
	end

  if (sAdmin) then
    -- hook.Add("slib:loadedUtils", "SFP.InterceptsAdmin", function()
      Aw:LogTrace("Loading sAdmin command hook")  
      sAdmin.banPly = function(ply, time, reason, admin)
        Aw:LogTrace("Intercepted sAdmin ban in favor or SFPortal: %s %s %s %s", ply:GetName(), ply:SteamID(), time, reason)
        admin = IsValid(admin) and admin:SteamID64() or "0"
        local timeLeft = time == 0 and slib.getLang("sadmin", sAdmin.config["language"], "eternity") or sAdmin.formatTime(time)
        
        -- sAdmin.addBan(sid64, time, reason, admin)
        MODULE:banPlayer(ply:GetName(), admin, ply:SteamID(), time, reason, 0)
        -- MODULE:banPlayer(admin_name, admin_steamid, steamid, time, reason, community)
        -- ply:Kick("\n"..string.format(sAdmin.config["ban_message"], admin == "0" and slib.getLang("sadmin", sAdmin.config["language"], "console") or admin, reason, timeLeft))
      end
    -- end)
  end
end

SFP:RegisterModule(MODULE)
SFP:RegisterCommand("syncbans", MODULE.Sync, MODULE)
SFP:RegisterCommand("ban", MODULE.Ban, MODULE)
SFP:RegisterCommand("unban", MODULE.UnBan, MODULE)
SFP:RegisterCommand("resync", MODULE.Migrations, MODULE)
SFP:RegisterCommand("updatebans", MODULE.Migrations, MODULE)