--[[
     Modules have no clientside interface
     But, you can always create CL_ file on the modules folder to interact with serverside modules.
]]--
SFP._tCustomJobs = SFP._tCustomJobs or {}

hook.Add( "InitPostEntity", "Ready", function()
  if not DarkRP then return end

 	DarkRP.createCategory {
    	name = "custom",
    	categorises = "jobs",
    	startExpanded = true,
    	color = Color(0, 107, 0, 255),
    	sortOrder = 100,
    }


    net.Start("SFP_DARKRP:RequestData")
    net.SendToServer()
end )

net.Receive("SFP_DARKRP:RemoveJob", function(xLen)

    local command = net.ReadString()
    local tJob, index =	DarkRP.getJobByCommand(command)
    Aw:LogTrace("SFP Requested us to remove a job .... [%s] %s", index, tJob.name)
    DarkRP.removeJob(index)
        
   if CLIENT and IsValid(DarkRP.getF4MenuPanel()) then 
            DarkRP.getF4MenuPanel():Remove() 
  end -- Rebuild entire F4 menu frame

end)


net.Receive("SFP_DARKRP:LoadJobs", function(xLen)

    local count = net.ReadUInt(16)
            Aw:LogTrace("Received loadjobs request from the server, total jobs: %i", count)
    for i = 1, count do
        local ammo = util.JSONToTable( net.ReadString() or {} )
        local category = net.ReadString()
        local chief = net.ReadBool()
        local color = net.ReadColor()
        local command = net.ReadString()
        local description = net.ReadString()
        local job_id = net.ReadUInt(16)
        local max = net.ReadInt(16)
        local model = util.JSONToTable( net.ReadString() or {} )
        local salary = net.ReadInt(32)
        local weapons =  util.JSONToTable( net.ReadString() or {} )
        -- Custom check is a serverside function, skip
        local license = net.ReadBool()
        local medic = net.ReadBool()
        local cook = net.ReadBool()
        local mayor = net.ReadBool()
        local name = net.ReadString()

        if category then
            Aw:LogTrace("Client check : Categories")
            for _, cat in pairs(DarkRP.getCategories().jobs) do
            	if cat.name == category then
                        Aw:LogTrace("Found existing category: %s for job: %s name - Not recreating category", category, name)
                else                     
                    DarkRP.createCategory {
                        name = category,
                        categorises = "jobs",
                        startExpanded = true,
                        color = color,
                        sortOrder = 100,
                    }   
                end
            end

        end

        DarkRP.createJob(name,{
            name = name,
            category = category,
            chief = chief,
            color = color,
            command = command,
            description = description,
            job_id = job_id,
            max = max,
            model = model,
            salary = salary,
            ammo = ammo,
            weapons = weapons,
            license = license,
            admin = 0,
            medic = medic,
            cook = cook,
            mayor = mayor
        })
    end
        
      if CLIENT and IsValid(DarkRP.getF4MenuPanel()) then 
        DarkRP.getF4MenuPanel():Remove() 
      end

end)
