SFP.NET = SFP.NET or {}

function SFP.NET:RequestAppealsList()
  net.Start("SFP_RequestAppealsList")
  net.SendToServer()
end

net.Receive("SFP_RequestServerInfo", function(xLen)
  SFP.NET:HandleServerInfoResponse(net.ReadTable())
end)

function SFP.NET:HandleServerInfoResponse(tInfo)
  hook.Run("SFP_UI_MESSAGE", "ServerInfo", "Success", tInfo)
end

function SFP.NET:RequestServerInfo()
  net.Start("SFP_RequestServerInfo")
  net.SendToServer()
end

net.Receive("SFP_RequestAppealsList", function(xLen)
  local tAppeals = {}
  
  local bytes_amount = net.ReadUInt(32)
  local compressedDATA = net.ReadData(bytes_amount)
  local decompressedDATA = util.Decompress(compressedDATA)

  local serializedData = util.JSONToTable( decompressedDATA )
  
  SFP.NET:HandleAppealsResponse(serializedData)
end)

function SFP.NET:HandleAppealsResponse(tAppeals)
  hook.Run("SFP_UI_MESSAGE", "BanAppeals", "Success", tAppeals)
end

net.Receive("SFP_RequestChatLog", function(xLen)
  local tChatLog = {}
  
  local bytes_amount = net.ReadUInt(32)
  local compressedDATA = net.ReadData(bytes_amount)
  local decompressedDATA = util.Decompress(compressedDATA)

  local serializedData = util.JSONToTable( decompressedDATA )
  
  SFP.NET:HandleChatLogResponse(serializedData)
end)

function SFP.NET:HandleChatLogResponse(tMessages)
  -- Message Channel, Message Panel, Messsage Type, Content table
  hook.Run("SFP_UI_MESSAGE", "ChatLog", "Success", tMessages)
end

function SFP.NET:RequestChatLog()
  net.Start("SFP_RequestChatLog")
  net.SendToServer()
end

function SFP.NET:AcceptAppeal( sTicketID )
  net.Start("SFP_AcceptAppeal")
    net.WriteString(sTicketID)
  net.SendToServer()
end

function SFP.NET:DenyAppeal( sTicketID )
  net.Start("SFP_DenyAppeal")
    net.WriteString(sTicketID)
  net.SendToServer()
end

function SFP.NET:AcceptAppeal( sTicketID, sBanID )
  net.Start("SFP_AcceptAppeal")
    net.WriteString(sTicketID)
    net.WriteString(sBanID)
  net.SendToServer()
end

net.Receive("SFP_UI_ERROR", function(xLen)
  hook.Run("SFP_UI_MESSAGE", net.ReadString(), "Error", {message = net.ReadString()})
end)

net.Receive("SFP_OpenMenu", function(xLen)
  if (SFP.Menu) then
    notification.AddLegacy( "Alredy open, maybe minimized?", 2, 3)
    return
  end
  SFP.Menu = vgui.Create('sfp:ui:frame')
  SFP.Menu:SetSize(math.Clamp(900, ScrW() * .6, ScrW()), math.Clamp(600, ScrH() * .8, ScrH()))
  SFP.Menu:Center()
  SFP.Menu:MakePopup()
  SFP.Menu.Originaltitle = "SFPortal - Menu"
end)

function SFP.NET:RequestSendMessage(sMessage)
  net.Start("SFP_SendMessage")
    net.WriteString(sMessage)
  net.SendToServer()
end


net.Receive("SFP_SendAppealMessage", function(xLen)
  local tMessage = net.ReadTable()
  hook.Run("SFP_UI_MESSAGE", "AppealMessage", "Success", tMessage)
end)

function SFP.NET:RequestSendAppealMessage(sMessage, sTicketID)
  net.Start("SFP_SendAppealMessage")
    net.WriteString(sMessage)
    net.WriteString(sTicketID)
  net.SendToServer()
end
