Aw.UI:CreateFont("AdminUI.ChatBubble", 18, "Montserrat Regular")

local pnl = {}

AccessorFunc(pnl, "m_claimer", "Claimer")

function pnl:Init()
    self.Player = nil
    self.LineH = 0
    self.Speech = ":( Error"

    self.speaker = self:Add("DPanel")
    self.speaker.Paint = nil

    self.avatar = self.speaker:Add("Aw.UI.Panel.Avatar")
    self.avatar:SetVertices(33)

    self.message = self:Add("DPanel")
    self.message.Paint = function(s,w,h)
        local tdpSpeaker = self.Player ~= LocalPlayer():SteamID64()
        local bubbleColor
        if tdpSpeaker then bubbleColor = Aw.UI.Theme.navbar end
        if self:GetClaimer() ~= nil and self.Player == self:GetClaimer() then bubbleColor = Aw.UI.Theme.staff end
        if not tdpSpeaker then bubbleColor = Aw.UI.Theme.accent end
        draw.RoundedBox(4, tdpSpeaker and 16 or 0, 0, tdpSpeaker and w or w - 16, h, bubbleColor)
    end

    self.Text = self.message:Add("RichText")
    self.Text:SetVerticalScrollbarEnabled( false)
    --self.Text:SetFont("AdminUI.ChatBubble")
    -- self.Text:SetColor(Color(255,255,255))
end

function pnl:PerformLayout(w,h)
    self:DockPadding(16, 0, 16, 0)

    self.speaker:Dock(self.Player ~= LocalPlayer():SteamID64() and LEFT or RIGHT)
    self.speaker:SetWide(48)
    self.speaker:IsMouseInputEnabled(false)

    self.avatar:SetSize( h < 48 and h or 48, h < 48 and h or 48 )
    self.avatar:SetPos( 0, 0 )
    self.avatar:IsMouseInputEnabled(false)

    self.message:Dock(FILL)
    self.message:IsMouseInputEnabled(false)

    self.Text:SetFontInternal("AdminUI.ChatBubble")
    self.Text:SetContentAlignment(5)
    self.Text:Dock(FILL)
    if (self.Player ~= LocalPlayer():SteamID64()) then
        self.Text:DockMargin(24, 8, 8, 8)
    else
        self.Text:DockMargin(8, 8, 8, 8)
    end
    self.Text:SetTall(self.Text:GetNumLines() * 18 + self.Text:GetNumLines() *4)
    self.Text:SetWide(w - self.speaker:GetWide() - 32)
    self.Text:SetPos(self.Player ~= LocalPlayer():SteamID64() and 27 or 16, h /2 - self.Text:GetTall()/2)


    self:SetTall( math.max( self.Text:GetTall() + 16 , 48 ) )
    for _, element in pairs(self:GetChildren()) do
        element:SetMouseInputEnabled(false)
    end
end

function pnl:SetText(sText, cChange)
    self.Speech = sText
    self.Text:InsertColorChange(Aw.UI.Theme.text.r,Aw.UI.Theme.text.g,Aw.UI.Theme.text.b, Aw.UI.Theme.text.a)
    self.Text:AppendText(self.Speech)
    self:InvalidateLayout(false)
end

function pnl:SetSpeaker(sid64)
    self.Player = sid64
    self.avatar:SetSteamID(sid64, 64)
    self:InvalidateLayout(false)
end

local mat_white = Material("vgui/white")

function pnl:Paint(w,h)
    local tdpSpeaker = self.Player ~= LocalPlayer():SteamID64()
    local bubbleColor
    if tdpSpeaker then bubbleColor = Aw.UI.Theme.navbar end
    if self:GetClaimer() ~= nil and self.Player == self:GetClaimer() then bubbleColor = Aw.UI.Theme.staff end
    if not tdpSpeaker then bubbleColor = Aw.UI.Theme.accent end
    surface.SetMaterial(mat_white)
    -- print(self:GetClaimer())
    surface.SetDrawColor(bubbleColor)
    surface.DrawTexturedRectRotated( tdpSpeaker and (48 + 16*2) or (w - 48 - 32), 48/2, 16, 16, 45 )
end

function pnl:OnCursorEntered()
    self:SetCursor("hand")
end

function pnl:OnMousePressed(sKeyCode)
    if keyCode == MOUSE_LEFT then return end
    Aw:OpenContextMenu("chat", { self.Player, self.Speech})
end

vgui.Register("AdminUI.ChatBubble", pnl, "EditablePanel")


local pnl = {}

Aw.UI:CreateFont("AdminUI.ChatBubbleAction", 12, "Montserrat Regular")

function pnl:Init()
    self.Text = "Action message :)"
    self:Dock(TOP)
    self:DockMargin(16, 8, 16, 8)
end

function pnl:PerformLayout(w,h)
    self:SetTall(16)
end

function pnl:Paint(w,h)
    surface.SetFont("AdminUI.ChatBubbleAction")
    local tw, th = surface.GetTextSize(self.Text)
    draw.RoundedBox(0, 0, h/2, w, 1, ColorAlpha(color_white, 10))
    draw.RoundedBox(0, w/2 - (tw + 16)/2, h/2 - (th + 4)/2, tw + 16, th + 4, Aw.UI.Theme.background)
    draw.SimpleText(self.Text, "AdminUI.ChatBubbleAction", w/2, h/2, ColorAlpha(Aw.UI.Theme.text, 50), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
end

function pnl:SetText(sMessage)
    self.Text = sMessage
end

vgui.Register("AdminUI.ChatBubble.Action", pnl, "EditablePanel")