local pnl = {}

function pnl:Init()
  local ChatLines = {}
  self.StopRefreshing = false

  self.scrollpanel = self:Add("Aw.UI.Panel.ScrollAnimated")
  -- self.scrollpanel:SetCanvas(self)
  self.scrollpanel:Dock(FILL)

  local lastId = 0

  self:AddHook("SFP_UI_MESSAGE", "chatlog:addToList", function(pnlSelf, sChannel, sEventName, tEventData)
    if (sChannel != "ChatLog") then 
      return 
    end
    if (sEventName != "Success") then 
      return 
    end

    for k, v in pairs(ChatLines) do
      local optmisticstart, optmisticend = string.find( k, "Optmistic")
      if (optmisticstart and optmisticend) then
        ChatLines[k]:Remove()
        ChatLines[k] = nil
      end
    end

    for k, v in pairs(tEventData) do
      if (ChatLines[v.ID]) then continue end

      ChatLines[v.ID] = self.scrollpanel:Add("AdminUI.ChatBubble")
      ChatLines[v.ID]:SetSpeaker(v.SteamID)
      ChatLines[v.ID]:SetText(v.Message)
      ChatLines[v.ID]:Dock(TOP)
      ChatLines[v.ID]:SetTall(64)
      ChatLines[v.ID]:DockMargin(8, 8, 8, 8)
      if (k == #tEventData) then
        timer.Simple(.1, function()
          self.scrollpanel:ScrollToChild(ChatLines[v.ID])
          if (SFP.Menu.Minimized) then
            notification.AddLegacy( "New staff message! (SFPortal)", 0, 5)
            if SFP.Menu.MessageCount then SFP.Menu.MessageCount = SFP.Menu.MessageCount + 1 else SFP.Menu.MessageCount = 1 end
            SFP.Menu:SetTitle(SFP.Menu.Originaltitle .. " (" .. SFP.Menu.MessageCount .. ")")
          end
        end)
      end
      lastId = v.ID
    end

  end)

  self.sendBoxWrapper = self:Add("DPanel")
  self.sendBoxWrapper:Dock(BOTTOM)
  self.sendBoxWrapper:SetTall(42)
  self.sendBoxWrapper:DockMargin(8, 8, 8, 8)
  self.sendBoxWrapper.Paint = nil

  self.input = self.sendBoxWrapper:Add("Aw.UI.Panel.TextEntry")
  self.input:Dock(FILL)
  self.input:SetPlaceholder("Type here...")
  self.input:OnEnter(function()
    if ( #string.Trim(self.input:GetText()) < 2 ) then
      self.input:SetText("")
      return
    end 
    SFP.NET:RequestSendMessage(self.input:GetText())
    ChatLines["Optmistic" .. lastId + 1] = self.scrollpanel:Add("AdminUI.ChatBubble")
    ChatLines["Optmistic" .. lastId + 1]:SetSpeaker(LocalPlayer():SteamID64())
    ChatLines["Optmistic" .. lastId + 1]:SetText(self.input:GetText())
    ChatLines["Optmistic" .. lastId + 1]:Dock(TOP)
    ChatLines["Optmistic" .. lastId + 1]:SetTall(64)
    ChatLines["Optmistic" .. lastId + 1]:DockMargin(8, 8, 8, 8)
    timer.Simple(.1, function()
      if (not ChatLines["Optmistic" .. lastId + 1]) then return end
      self.scrollpanel:ScrollToChild(ChatLines["Optmistic" .. lastId + 1])
    end)
    self.input:SetText("")
  end)

  
  self.send = self.sendBoxWrapper:Add("Aw.UI.Panel.Button")
  self.send:SetWide(64)
  self.send:Dock(RIGHT)
  self.send:SetText("Send")
  self.send:SetBody(self.sendBoxWrapper)
  self.send:SetDisabled(false)
  self.send:SetBordered(false)
  self.send:SetBackgroundColor(Aw.UI.Theme.navbar)
  self.send:SetMargin(16)
  self.send:SetRadius(8)
  self.send:Deploy()
  self.send.DoClick = function()
    if ( #string.Trim(self.input:GetText()) < 2 ) then
      self.input:SetText("")
      return
    end 
    SFP.NET:RequestSendMessage(self.input:GetText())
    ChatLines["Optmistic" .. lastId + 1] = self.scrollpanel:Add("AdminUI.ChatBubble")
    ChatLines["Optmistic" .. lastId + 1]:SetSpeaker(LocalPlayer():SteamID64())
    ChatLines["Optmistic" .. lastId + 1]:SetText(self.input:GetText())
    ChatLines["Optmistic" .. lastId + 1]:Dock(TOP)
    ChatLines["Optmistic" .. lastId + 1]:SetTall(64)
    ChatLines["Optmistic" .. lastId + 1]:DockMargin(8, 8, 8, 8)
    timer.Simple(.1, function()
      self.scrollpanel:ScrollToChild(ChatLines["Optmistic" .. lastId + 1])
    end)
    self.input:SetText("")
  end

  self.stopRefresh = self.sendBoxWrapper:Add("Aw.UI.Panel.Button")
  self.stopRefresh:SetWide(120)
  self.stopRefresh:Dock(RIGHT)
  self.stopRefresh:SetText(self.StopRefreshing and "Enable refresh" or " Stop refresh")
  self.stopRefresh:SetBody(self.sendBoxWrapper)
  self.stopRefresh:SetDisabled(false)
  self.stopRefresh:SetBordered(false)
  self.stopRefresh:SetBackgroundColor(Aw.UI.Theme.navbar)
  self.stopRefresh:SetMargin(16)
  self.stopRefresh:SetRadius(8)
  self.stopRefresh:Deploy()
  self.stopRefresh:DockMargin(8, 0, 8, 0)
  self.stopRefresh.DoClick = function()
    self.StopRefreshing = !self.StopRefreshing
    self.stopRefresh:SetText(self.StopRefreshing and "Enable refresh" or " Stop refresh")
  end
end

function pnl:PerformLayout(w,h)
  -- self.input:SetWide( w - 84 * 2)
end

function pnl:Paint(w,h)
end

function pnl:Activate()
  SFP.NET:RequestChatLog()
  self:AddTimer("GetNewMessages", 3, 0, function()
    if self.StopRefreshing then return end
    SFP.NET:RequestChatLog()
  end)
end

vgui.Register("sfp:ui:pages:staffchat", pnl, "EditablePanel")