local pnl = {}

function pnl:Init()
  self.Activated = false
  Aw.UI:CreateFont("sfp_ui_infovalue", 18)

  self.connectionTitle = self:Add("AdminUI.TextRibbon")
    self.connectionTitle:Dock(TOP)
    self.connectionTitle:SetText("Connection Status")
    self.connectionTitle:SetTall( self.connectionTitle:GetTall() )

  self.connectionStatus = self:Add("DLabel")
    self.connectionStatus:Dock(TOP)
    self.connectionStatus:SetText("Verifying")
    self.connectionStatus:SetFont("sfp_ui_infovalue")
    self.connectionStatus:DockMargin(12,12,12,12)
  
  
  self.databaseTitle = self:Add("AdminUI.TextRibbon")
    self.databaseTitle:Dock(TOP)
    self.databaseTitle:SetText("Database status")
    self.databaseTitle:SetTall( self.connectionTitle:GetTall() )

  self.databaseStatus = self:Add("DLabel")
    self.databaseStatus:Dock(TOP)
    self.databaseStatus:SetText("Verifying")
    self.databaseStatus:SetFont("sfp_ui_infovalue")
    self.databaseStatus:DockMargin(12,12,12,12)

  self.modulesTitle = self:Add("AdminUI.TextRibbon")
    self.modulesTitle:Dock(TOP)   
    self.modulesTitle:SetText("Loaded Modules")
    self.modulesTitle:SetTall( self.modulesTitle:GetTall() )
  
  self.modulesStatus = self:Add("DListView")
    self.modulesStatus:Dock(TOP)
    self.modulesStatus:AddColumn("ID")
    self.modulesStatus:AddColumn("Name")
    self.modulesStatus:AddColumn("Version")
    self.modulesStatus:DockMargin(12,12,12,12)
    self.modulesStatus:SetHeaderHeight(32)
    self.modulesStatus.Paint = function(s,w,h)
      local hh = s:GetHeaderHeight()
      draw.RoundedBox(4, 0, hh, w, h - hh, Aw.UI.Theme.navbar)
    end
    for k, pnl in pairs( self.modulesStatus:GetChildren()) do
     if pnl:GetName() == 'DListView_Column' then
        pnl.Header:SetTextColor(Aw.UI.Theme.text)
        pnl.Header:SetContentAlignment(4)
        pnl.Header:SetTextInset(8, 0)
        pnl.Header.Paint = function(s,w,h)
          draw.RoundedBoxEx(4, 0, 0, w, h, Aw.UI.Theme.accent, false, false, false, false)
          draw.RoundedBox(0, w - 1, 0, 2, h, Aw.UI.Theme.background)
        end
      end
    end

  self.commandsTitle = self:Add("AdminUI.TextRibbon")
    self.commandsTitle:Dock(TOP)
    self.commandsTitle:SetText("Registered commands")
    self.commandsTitle:SetTall( self.commandsTitle:GetTall() )
    
    self.commandsStatus = self:Add("DListView")
    self.commandsStatus:Dock(TOP)
    self.commandsStatus:AddColumn("Command")
    self.commandsStatus:DockMargin(12,12,12,12)
    self.commandsStatus:SetHeaderHeight(32)
    self.commandsStatus.Paint = function(s,w,h)
      local hh = s:GetHeaderHeight()
      draw.RoundedBox(4, 0, hh, w, h - hh, Aw.UI.Theme.navbar)
    end
    for k, pnl in pairs( self.commandsStatus:GetChildren()) do
     if pnl:GetName() == 'DListView_Column' then
        pnl.Header:SetTextColor(Aw.UI.Theme.text)
        pnl.Header:SetContentAlignment(4)
        pnl.Header:SetTextInset(8, 0)
        pnl.Header.Paint = function(s,w,h)
          draw.RoundedBoxEx(4, 0, 0, w, h, Aw.UI.Theme.accent, false, false, false, false)
          draw.RoundedBox(0, w - 1, 0, 2, h, Aw.UI.Theme.background)
        end
      end
    end


  
  self:AddHook("SFP_UI_MESSAGE", "serverinfo:addToList", function(pnlSelf, sChannel, sEventName, tEventData)
    if (not sChannel == "serverinfo") then
      return
    end

    if sEventName == "Error" then
      -- self.connectionStatus:SetText(tEventData.message or "Unknown error")
      -- self.connectionStatus:SetTextColor(Aw.UI.Theme.red)
    end
    
    for k, v in pairs (tEventData) do
      if k == "database" then
        self.databaseStatus:SetText(tostring(v) == "true" and "Connected" or "Disconnected")
        self.databaseStatus:SetTextColor(Aw.UI.Theme.green)
      elseif k == "modules" then
        for _, moduleInfo in pairs(v) do
          self.modulesStatus:AddLine(moduleInfo.id, moduleInfo.name, moduleInfo.version)
          self.modulesStatus:SetTall( 28 + 19 * table.Count(v))
        end
        for _, pnl in pairs( self.modulesStatus:GetLines() ) do
          pnl.Columns[1]:SetTextColor(Aw.UI.Theme.text)
          pnl.Columns[2]:SetTextColor(Aw.UI.Theme.text)
          pnl.Columns[3]:SetTextColor(Aw.UI.Theme.text)
        end
      elseif k == "commands" then
        for _, commandInfo in pairs(v) do
          self.commandsStatus:AddLine(commandInfo.id)
          self.commandsStatus:SetTall( 28 + 19 * table.Count(v))
          for _, pnl in pairs( self.commandsStatus:GetLines() ) do
            pnl.Columns[1]:SetTextColor(Aw.UI.Theme.text)
          end
        end
      elseif k == "serverstatus" then
        self.connectionStatus:SetText(tostring(v))
        self.connectionStatus:SetTextColor(Aw.UI.Theme.green)
      end
    end

  end)

end

function pnl:PerformLayout(w,h)
end

function pnl:Paint(w,h)
end

function pnl:Activate()
  if (self.Activated) then return end
  SFP.NET:RequestServerInfo()
  self.Activated = true
end

vgui.Register("sfp:ui:pages:stats", pnl, "EditablePanel")